import LicenseSpring

import Combine
import SwiftUI

@main
class AppDelegate: NSObject, NSApplicationDelegate {
    @IBOutlet weak var window: NSWindow!
    
    func applicationDidFinishLaunching(_ aNotification: Notification) {
        // Create the SwiftUI view that provides the window contents.
        let contentView = ContentView()
            .environmentObject(ViewUpdaterHack.shared)
        
        // Create the window and set the content view.
        window.setFrameAutosaveName("LicenseSpring")
        window.contentView = NSHostingView(rootView: contentView)
        window.makeKeyAndOrderFront(nil)
    }
    
    func applicationShouldTerminateAfterLastWindowClosed(_ sender: NSApplication) -> Bool {
        true
    }
}

class AppOpenURLManager: NSObject, @unchecked Sendable  {
    static let shared = AppOpenURLManager()
    
    var publisher: AnyPublisher<String, Never> { subject.eraseToAnyPublisher() }
    private let subject = PassthroughSubject<String, Never>()
    
    private override init() {
        super.init()
        
        NSAppleEventManager.shared().setEventHandler(
            self,
            andSelector: #selector(Self.handleEvent(_:with:)),
            forEventClass: AEEventClass(kInternetEventClass),
            andEventID: AEEventID(kAEGetURL)
        )
    }
    
    @objc
    private func handleEvent(_ event: NSAppleEventDescriptor, with replyEvent: NSAppleEventDescriptor) {
        guard let urlString = event.paramDescriptor(forKeyword: AEKeyword(keyDirectObject))?.stringValue else {
            return
        }
        subject.send(urlString)
    }
}
